package kb.presentation;

// Imports Enhydra
import org.enhydra.xml.xmlc.*;
import org.w3c.dom.*;
import org.w3c.dom.html.*;
import com.lutris.appserver.server.sql.*;
import com.lutris.appserver.server.Enhydra;
import com.lutris.appserver.server.httpPresentation.*;
import com.lutris.logging.*;
import kb.data.*;
import kb.business.*;
import kb.presentation.*;

public class Details extends BasePO {
  protected LogChannel log = Enhydra.getLogChannel();

  public void run(HttpPresentationComms comms) 
              throws HttpPresentationException {
    // Rcupre les paramtres dans la requte HTTP
    String handle = comms.request.getParameter("id");
    // Rcupre les noms correspondants
    kbManager pm = new kbManager();
    InfoDO info = pm.getInfo(handle);
    DetailsPage details = (DetailsPage) create(comms, "kb.presentation.Details");
    // Rcupre les informations dans ce document
    Element infoElement = details.getTagInfo();
    // Retire les attributs id
    infoElement.removeAttribute("id");
    details.getTagType().removeAttribute("id");
    details.getTagTitre().removeAttribute("id");
    details.getTagContenu().removeAttribute("id");
    Node infoContainer = infoElement.getParentNode();
    if (info == null) {
      Node errMsg = details.createElement("em");
      errMsg.appendChild(details.createTextNode("Erreur lors de la rcupration des informations dans la base de donnes"));
      infoContainer.replaceChild(errMsg, infoElement);
      comms.response.writeDOM(details);
      return;
    } 
    try {
      String lstitre = info.getType() + " " + info.getTitre();
      String lscontenu = info.getContenu();
      details.setTextTitre(lstitre);
      details.setTextContenu(lscontenu);
    } catch (Exception e) {
      e.printStackTrace(System.out);
      log.write(Logger.CRITICAL, "Erreur lors la rcupration du DOs");
      log.write(Logger.CRITICAL, e.toString());
    } 
    // Affiche le
    comms.response.writeDOM(details);
  } 
}
